/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.util;

import java.io.File;
import java.io.IOException;
import jtbcore.util.ProcUtil;

public class SOfficeUtil {
    protected static boolean sofficeLookedup = false;
    protected static File sofficeFile = null;

    public static boolean sofficeInstalled() {
        File f = SOfficeUtil.lookupSOffice();
        return f != null;
    }

    public static void convertToPdf(String doc, String outputDir) throws IOException {
        SOfficeUtil.convertToPdf(new File(doc), new File(outputDir));
    }

    public static void convertToPdf(File doc, File outputDir) throws IOException {
        File soffice = SOfficeUtil.lookupSOffice();
        ProcUtil.execReturnInt(soffice.getAbsolutePath(), "--headless", "--convert-to", "pdf", "--outdir", outputDir.getAbsolutePath(), doc.getAbsolutePath());
    }

    public static File lookupSOffice() {
        if (sofficeLookedup) {
            if (sofficeFile != null && sofficeFile.exists()) {
                return sofficeFile;
            }
            return null;
        }
        File bin = null;
        if (ProcUtil.isWindows()) {
            String n;
            File f;
            int n2;
            int n3;
            File[] fileArray;
            File folder = new File("C:\\Program Files");
            if (folder.exists() && folder.isDirectory()) {
                fileArray = folder.listFiles();
                n3 = fileArray.length;
                n2 = 0;
                while (n2 < n3) {
                    f = fileArray[n2];
                    n = f.getName().toLowerCase();
                    if (n.contains("libreoffice") || n.contains("openoffice")) {
                        bin = new File(f.getAbsolutePath() + "\\program\\soffice.exe");
                        break;
                    }
                    ++n2;
                }
            }
            if ((folder = new File("C:\\Program Files (x86)")).exists() && folder.isDirectory()) {
                fileArray = folder.listFiles();
                n3 = fileArray.length;
                n2 = 0;
                while (n2 < n3) {
                    f = fileArray[n2];
                    n = f.getName().toLowerCase();
                    if (n.contains("libreoffice") || n.contains("openoffice")) {
                        bin = new File(f.getAbsolutePath() + "\\program\\soffice.exe");
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (ProcUtil.isLinux()) {
            bin = new File("/usr/bin/soffice");
        }
        if (ProcUtil.isMac()) {
            bin = new File("/usr/bin/soffice");
        }
        sofficeLookedup = true;
        sofficeFile = bin;
        if (bin != null && bin.exists()) {
            return bin;
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            SOfficeUtil.convertToPdf("C:\\Users\\timvw\\Documents\\test doc 1.odt", "C:\\Users\\timvw\\Documents");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

